<?php

if (!defined('ABSPATH')) {
    exit;
}


require_once GP_GET_PLUGIN_DIR . 'includes/class-gp-i18n.php';
require_once GP_GET_PLUGIN_DIR . 'includes/class-gp-utils.php';
require_once GP_GET_PLUGIN_DIR . 'includes/class-gp-repository.php';
require_once GP_GET_PLUGIN_DIR . 'includes/class-gp-access.php';
require_once GP_GET_PLUGIN_DIR . 'includes/class-gp-plugin-manager.php';
require_once GP_GET_PLUGIN_DIR . 'admin/class-gp-admin.php';

final class GP_Get_Plugin
{
    public const VERSION = GP_GET_PLUGIN_VERSION;

    // Top menu slug (Installed)
    public const SLUG = 'get-plugin';

    // Submenu slug (Not installed)
    public const PAGE_NOT_INSTALLED = 'get-plugin-not-installed';

    // Repo
    public const REPO_URL      = 'https://core24.ir/';
    public const MANIFEST_PATH = 'manifest.php';
    public const PACKAGE_PATH  = 'package.php';

    // Allowed domains file in repo root (public_html/allowed_domains)
    public const ALLOWED_DOMAINS_PATH = 'allowed_domains';

    // Manifest cache
    public const CACHE_KEY = 'gp_manifest_cache_v5';
    public const CACHE_TTL = 120; // seconds

    // Update count cache (tied to manifest generated_at)
    public const UPDATE_CACHE_KEY = 'gp_updates_count_v4';
    public const UPDATE_CACHE_TTL = 3600; // seconds

    // Allowed domains cache
    public const ALLOWED_CACHE_KEY = 'gp_allowed_domains_cache_v1';
    public const ALLOWED_CACHE_TTL = 300; // seconds

    // Post-redirect notice cache
    public const NOTICE_KEY = 'gp_admin_notice_v4';

    private static ?self $instance = null;

    public GP_Repository $repo;
    public GP_Access $access;
    public GP_Plugin_Manager $pm;
    public GP_Admin $admin;

    private function __construct()
    {
        $this->repo = new GP_Repository([
            'repo_url'             => self::REPO_URL,
            'manifest_path'        => self::MANIFEST_PATH,
            'package_path'         => self::PACKAGE_PATH,
            'allowed_domains_path' => self::ALLOWED_DOMAINS_PATH,
            'manifest_cache_key'   => self::CACHE_KEY,
            'manifest_cache_ttl'   => self::CACHE_TTL,
            'allowed_cache_key'    => self::ALLOWED_CACHE_KEY,
            'allowed_cache_ttl'    => self::ALLOWED_CACHE_TTL,
        ]);

        $this->access = new GP_Access($this->repo);

        $this->pm = new GP_Plugin_Manager($this->repo, $this->access, [
            'update_cache_key' => self::UPDATE_CACHE_KEY,
            'update_cache_ttl' => self::UPDATE_CACHE_TTL,
        ]);

        $this->admin = new GP_Admin($this, $this->repo, $this->access, $this->pm);
    }

    public static function instance(): self
    {
        if (self::$instance === null) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    public function init(): void
    {
        $this->admin->init();
    }

    public static function activate(): void
    {
        self::instance()->on_activate();
    }

    private function on_activate(): void
    {
        add_option('gp_just_activated', '1', '', false);
        $this->invalidate_caches();
    }

    public function invalidate_caches(): void
    {
        $this->repo->invalidate_caches();
        $this->pm->invalidate_caches();
    }
}
