<?php

if (!defined('ABSPATH')) {
    exit;
}

final class GP_Access
{
    private GP_Repository $repo;

    public function __construct(GP_Repository $repo)
    {
        $this->repo = $repo;
    }

    /**
     * @return array<string,mixed>
     */
    public function check_access(bool $force_refresh = false): array
    {
        $site = GP_Utils::normalize_url_for_compare(home_url('/'));

        $data = $this->repo->get_allowed_domains_data($force_refresh);
        if (empty($data['ok'])) {
            return [
                'allowed' => false,
                'site'    => $site,
                'domains' => [],
                'error'   => isset($data['error']) ? (string) $data['error'] : 'Access check failed.',
                'source'  => isset($data['source']) ? (string) $data['source'] : '',
            ];
        }

        $domains = isset($data['domains']) && is_array($data['domains']) ? $data['domains'] : [];
        $allowed = in_array($site, $domains, true);

        return [
            'allowed' => $allowed,
            'site'    => $site,
            'domains' => $domains,
            'error'   => '',
            'source'  => isset($data['source']) ? (string) $data['source'] : '',
        ];
    }
}
