<?php
/**
 * Plugin Name: Get yaseomi plugins
 * Plugin URI:  https://core24.ir/
 * Description: Manage private plugins from plugins.yaseomi.com (Installed / Not installed) with bulk actions. Update bubble & notice ONLY for installed plugins with updates.
 * Version:     1.3.6
 * Author:      yaseomi.com
 * Author URI:  yaseomi.com
 * Text Domain: get-plugin
 * Domain Path: /languages
 */

if (!defined('ABSPATH')) {
    exit;
}

define('GP_GET_PLUGIN_FILE', __FILE__);
define('GP_GET_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('GP_GET_PLUGIN_URL', plugin_dir_url(__FILE__));
define('GP_GET_PLUGIN_VERSION', '1.3.6');

require_once GP_GET_PLUGIN_DIR . 'includes/class-gp-get-plugin.php';

register_activation_hook(__FILE__, ['GP_Get_Plugin', 'activate']);

add_action('plugins_loaded', static function (): void {
    load_plugin_textdomain('get-plugin', false, dirname(plugin_basename(GP_GET_PLUGIN_FILE)) . '/languages');
    GP_Get_Plugin::instance()->init();
});
